package gov.va.med.mhv.getcare.web.compare;

import java.util.Comparator;

import gov.va.med.mhv.getcare.common.dto.TreatmentFacilityDTO;

public class TreatmentFacilityDTOByTypeCompare implements Comparator<TreatmentFacilityDTO> {
	
	boolean ascending = true;
	
	public TreatmentFacilityDTOByTypeCompare() {		
	}

	public TreatmentFacilityDTOByTypeCompare(boolean ascending) {	
		this.ascending = ascending;
	}

	@Override
	public int compare(TreatmentFacilityDTO o1, TreatmentFacilityDTO o2) {
		// home facility is first in list
		if (o1.getHomeFacility()) {
			return ascending ? -1 : 1;
		}
		if (o2.getHomeFacility()) {
			return ascending ? 1 : -1;
		}

		return o1.getDisplayFacilityType().compareToIgnoreCase(o2.getDisplayFacilityType());
	}

}
